/*! \file 
**********************************************************************************
* Title:                            Discretix SST API Types header file
*
* Filename:                         nvs_thread.h.h
*
* Project, Target, subsystem:       NVS, Host IF
* 
* Created:                          26.07.2007
*
* Modified:                         26.07.2007
*
* \Author                           Ira Boguslavsky
*
* \Remarks                        
*           Copyright (C) 2006 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

#ifndef _NVS_THREAD_H_
#define _NVS_THREAD_H_

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/
#include "nvs_host_def.h"
#include "DX_VOS_BaseTypes.h"

#ifdef __cplusplus
extern "C"
{
#endif

    /************************ Defines ******************************/
   

    /************************ Public Functions **********************/

	/**
	* @brief NVSHost_Parser initializes the NVS deals with a SeP request for NVS operation
	*
	* @return DxError_t - On success the value DX_SUCCESS is returned, 
	*                     On failure the following values:
	*
	*/                                                        

    DxError_t NVSHost_Parser                 (void);

	#ifdef SST_SEP_SIMULATOR_ENV
		/*for simulator thread*/
		DxError_t NVSThread_ProtocolFunction     (void *pData);
	#endif


#ifdef __cplusplus
}
#endif

#endif

